# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 3
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    current_round = len(my_history)
    
    # Check if opponent's code has hard-coded defection
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Early rounds (1-4): Tit-for-tat
    if current_round < 5:
        return opp_history[-1]
    
    # Mid rounds (5-7): Test opponent's tolerance
    if 5 <= current_round < 8:
        if all(move == "C" for move in opp_history[:4]):
            return "D" if current_round == 5 else opp_history[-1]
        else:
            return opp_history[-1]
    
    # Late rounds (8-10): Defect if opponent defected in last 2 rounds, else alternate
    if current_round >= 8:
        if len(opp_history) >= 2 and opp_history[-2] == "D" and opp_history[-1] == "D":
            return "D"
        else:
            return "D" if current_round % 2 == 0 else "C"
    
    return "C"